<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class SurveyCoordinate extends Model
{
    use HasFactory;

    protected $table = 'survey_coordinates';
    
    protected $fillable = [
        'peninjauan_id',
        'sistem_koordinat',
        'zona_utm',
        'epsg_code',
        'tanggal_pengukuran',
        'tahun_pengukuran',
        'petugas_ukur',
        'geometry',
        'total_area_m2',
        'perimeter_m',
        'bbox_north',
        'bbox_south',
        'bbox_east',
        'bbox_west',
        'catatan_koordinat',
        'geometry_type',
        'is_validated'
    ];

    protected $casts = [
        'tanggal_pengukuran' => 'date',
        'geometry' => 'array',
        'total_area_m2' => 'decimal:2',
        'perimeter_m' => 'decimal:2',
        'bbox_north' => 'decimal:8',
        'bbox_south' => 'decimal:8',
        'bbox_east' => 'decimal:8',
        'bbox_west' => 'decimal:8',
        'is_validated' => 'boolean'
    ];

    // Relationships
    public function peninjauan(): BelongsTo
    {
        return $this->belongsTo(Peninjauan::class);
    }

    public function coordinatePoints(): HasMany
    {
        return $this->hasMany(CoordinatePoint::class);
    }

    // Helper methods
    public function getGeoJsonAttribute()
    {
        return $this->geometry;
    }

    public function getBoundingBoxAttribute()
    {
        return [
            'north' => $this->bbox_north,
            'south' => $this->bbox_south,
            'east' => $this->bbox_east,
            'west' => $this->bbox_west
        ];
    }
}